package org.eu.net.pool.hexic.mixin;

import at.petrak.hexcasting.api.casting.eval.vm.CastingVM;
import at.petrak.hexcasting.api.casting.iota.GarbageIota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.iota.ListIota;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

import static net.minecraft.class_1802.field_38746;

@Mixin(class_1792.class)
public class ItemMixin {
    @Inject(method = "appendTooltip", at = @At("TAIL"))
    void appendTooltip(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context, CallbackInfo ci) {
        if ((Object) this != field_38746) return; {
            class_2487 tag = stack.method_7969();
            if (tag == null) return;
            if (tag.method_10573("hexic:memory", class_2520.field_33259))
                tooltip.add(class_2561.method_43471("hexic.spell_memory").method_27694(s -> s.method_36139(0xfc77be)));
        }
    }

    @Inject(method = "use", at = @At("HEAD"), cancellable = true)
    void use(class_1937 world, class_1657 user, class_1268 hand, CallbackInfoReturnable<class_1271<class_1799>> cir) {
        if ((Object) this != field_38746) return;
        class_1799 stack = user.method_5998(hand);
        class_2487 nbt = stack.method_7969();
        if (nbt == null) return;
        class_2499 patterns = nbt.method_10554("hexic:memory", class_2520.field_33260);
        if (patterns.isEmpty() || world.field_9236 || !(world instanceof class_3218 serverWorld && user instanceof class_3222 serverPlayer)) return;
        CastingVM staffcast = IXplatAbstractions.INSTANCE.getStaffcastVM(serverPlayer, hand);
        stack.method_7934(1);
        class_2487 newNbt = nbt.method_10553();
        newNbt.method_10551("hexic:memory");
        class_1799 newStack = new class_1799(field_38746);
        if (!newNbt.method_33133()) newStack.method_7980(newNbt);
        try {
            staffcast.queueExecuteAndWrapIotas(patterns.stream().map(e -> e instanceof class_2487 c ? IotaType.deserialize(c, serverWorld) : new GarbageIota()).toList(), serverWorld);
            IXplatAbstractions.INSTANCE.setStaffcastImage(serverPlayer, staffcast.getImage());
            cir.setReturnValue(class_1271.method_22428(stack));
        } finally {
            user.method_31548().method_7398(newStack);
        }
    }
}
